/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.entities.components.FurnitureInventoryComponent;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalFailedException;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.WorkOnJobGoal;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HaulingComponent;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.JobCompletedMessage;

public class CollectItemFromFurnitureInventoryGoal
extends Goal {
    private final long targetItemId;
    private final TiledMap map;
    private final MessageDispatcher messageDispatcher;
    private final Job parentJob;
    private boolean itemPickedUp = false;

    public CollectItemFromFurnitureInventoryGoal(Entity parentEntity, WorkOnJobGoal workOnJobGoal, MessageDispatcher messageDispatcher, long targetItemId, TiledMap map) {
        super(parentEntity);
        this.targetItemId = targetItemId;
        this.map = map;
        this.parentJob = workOnJobGoal.getAssignedJob();
        this.messageDispatcher = messageDispatcher;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        MapTile currentTile = this.map.getTile(this.parentEntity.getLocationComponent().getWorldPosition());
        Entity targetInventoryItem = null;
        FurnitureInventoryComponent targetInventoryComponent = null;
        for (MapTile neighbourTile : this.map.getNeighbours(currentTile.getTileX(), currentTile.getTileY()).values()) {
            for (Entity neighbourEntity : neighbourTile.getEntities()) {
                FurnitureInventoryComponent inventoryComponent;
                if (!neighbourEntity.getType().equals((Object)EntityType.FURNITURE) || (inventoryComponent = neighbourEntity.getComponent(FurnitureInventoryComponent.class)) == null) continue;
                targetInventoryComponent = inventoryComponent;
                for (Entity inventoryItem : inventoryComponent.getInventoryItems()) {
                    if (inventoryItem.getId() != this.targetItemId) continue;
                    targetInventoryItem = inventoryItem;
                    break;
                }
                if (targetInventoryItem == null) continue;
                break;
            }
            if (targetInventoryItem == null) continue;
            break;
        }
        if (targetInventoryItem == null) {
            throw new GoalFailedException("Could not find item to collect");
        }
        ItemEntityAttributes targetItemAttributes = (ItemEntityAttributes)targetInventoryItem.getPhysicalEntityComponent().getAttributes();
        int quantityToPick = Math.min(targetItemAttributes.getQuantity(), targetItemAttributes.getItemType().getMaxHauledAtOnce());
        if (quantityToPick < targetItemAttributes.getQuantity()) {
            Job collectItemJob = new Job(JobType.COLLECT_ITEM);
            collectItemJob.setTargetEntityId(this.targetItemId);
            collectItemJob.setJobLocation(currentTile.getTilePosition());
            collectItemJob.setJobState(JobState.ASSIGNABLE);
            collectItemJob.setRequiredProfession(this.parentJob.getRequiredProfession());
            this.messageDispatcher.dispatchMessage(609, collectItemJob);
        }
        Entity clonedItem = targetInventoryItem.clone(this.messageDispatcher, this.map);
        targetItemAttributes.setNumAllocated(targetItemAttributes.getNumAllocated() - quantityToPick);
        targetItemAttributes.setQuantity(targetItemAttributes.getQuantity() - quantityToPick);
        ItemEntityAttributes cloneAttributes = (ItemEntityAttributes)clonedItem.getPhysicalEntityComponent().getAttributes();
        cloneAttributes.setQuantity(quantityToPick);
        cloneAttributes.setNumAllocated(quantityToPick);
        HaulingComponent haulingComponent = this.parentEntity.getOrCreateComponent(HaulingComponent.class);
        haulingComponent.setHauledItem(clonedItem, this.messageDispatcher);
        clonedItem.getLocationComponent().setWorldPosition(null, false);
        this.messageDispatcher.dispatchMessage(700, clonedItem);
        this.messageDispatcher.dispatchMessage(604, new JobCompletedMessage(this.parentJob, this.parentEntity.getComponent(ProfessionsComponent.class), this.parentEntity));
        if (targetItemAttributes.getQuantity() <= 0) {
            this.messageDispatcher.dispatchMessage(322, new EntityMessage(targetInventoryItem.getId()));
            targetInventoryComponent.remove(targetInventoryItem);
        } else {
            this.messageDispatcher.dispatchMessage(324, targetInventoryItem);
        }
        this.itemPickedUp = true;
    }

    @Override
    public boolean isComplete() {
        return this.itemPickedUp;
    }
}

